/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWFieldNameCellEditor;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWParametersTable;
import filenet.vw.toolkit.design.property.tables.VWParametersTableModel;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWParametersDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener,
ListSelectionListener,
TableModelListener,
IVWToolbarBorderActionListener,
DocumentListener {
    private static final int FIXED_COLUMN_WIDTH = 20;
    private VWToolbarBorder m_parametersToolbar = null;
    private VWParametersTable m_parametersTable = null;
    private VWParametersTableModel m_parametersTableModel = null;
    private JTextArea m_descriptionTextArea = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDef = null;
    private boolean m_isFirstTime = true;

    public VWParametersDialog(Frame parent, VWAuthPropertyData authPropertyData, VWStepDefinition stepDef) {
        super(parent);
        this.m_authPropertyData = authPropertyData;
        this.m_stepDef = stepDef;
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(VWResource.s_stepParametersStr);
        Dimension dim = VWStringUtils.stringToDimension("685,445");
        if (dim != null) {
            this.setSize(dim);
        }
        this.initParametersControls();
        this.initDialogControls();
        this.reinitialize();
    }

    void reinitialize() {
        try {
            this.m_parametersTableModel.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_parametersTable != null) {
                this.m_parametersTable.fitColumnsInTable();
            }
        }
    }

    public void windowClosing(WindowEvent event) {
        this.m_parametersTable.stopEditing();
        this.setVisible(false);
    }

    public void changedUpdate(DocumentEvent e) {
        this.onDescription();
    }

    public void insertUpdate(DocumentEvent e) {
        this.onDescription();
    }

    public void removeUpdate(DocumentEvent e) {
        this.onDescription();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_closeButton) {
                this.performClose();
            } else if (source == this.m_helpButton) {
                this.performHelp();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        int id = event.getID();
        Object src = event.getSource();
        if (src == this.m_parametersToolbar) {
            switch (id) {
                case 0x10000000: {
                    this.performDeleteAction();
                }
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0 || nRow > this.m_parametersTable.getRowCount()) {
                    nRow = 0;
                }
                if (nRow == this.m_parametersTable.getSelectedRow()) {
                    this.m_parametersTable.clearSelection();
                }
                this.m_parametersTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int[] rows = this.m_parametersTable.getSelectedRows();
            int nRowCount = this.m_parametersTableModel.getRowCount();
            int emptyRowIndex = nRowCount - 1;
            if (rows != null && rows.length > 0) {
                boolean bCanDelete = true;
                this.m_parametersToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
                for (int i = 0; i < rows.length; ++i) {
                    if (rows[i] != emptyRowIndex) continue;
                    bCanDelete = false;
                    break;
                }
                if (bCanDelete) {
                    this.m_parametersToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolbar.getClientPanel(), 1, Integer.MAX_VALUE));
                }
                this.updateControlValues(rows[0]);
                if (rows.length > 1) {
                    this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                    this.m_descriptionTextArea.setText("");
                    this.m_descriptionTextArea.setEnabled(false);
                    this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                }
            }
        }
    }

    private void initParametersControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.8;
            gbCons.insets = new Insets(2, 2, 0, 2);
            this.m_parametersToolbar = new VWToolbarBorder(VWResource.s_parametersStr, 0x10000000);
            this.m_parametersToolbar.addToolbarBorderActionNotifier(this);
            this.getContentPane().add((Component)this.m_parametersToolbar, gbCons);
            JPanel parametersPanel = this.m_parametersToolbar.getClientPanel();
            parametersPanel.setLayout(new BorderLayout());
            this.m_parametersTableModel = new VWParametersTableModel(this.m_authPropertyData, this.m_stepDef);
            this.m_parametersTable = new VWParametersTable(this.m_parametersTableModel);
            this.m_parametersTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_parametersTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_parametersTableModel.addTableModelListener(this);
            this.m_parametersTable.setRowSelectionAllowed(true);
            this.m_parametersTable.getSelectionModel().addListSelectionListener(this);
            this.m_parametersTable.getSelectionModel().setSelectionMode(0);
            parametersPanel.add(new JScrollPane(this.m_parametersTable));
            TableColumn tcElement = this.m_parametersTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellEditor(new VWFieldNameCellEditor(this.m_authPropertyData));
            }
            if ((tcElement = this.m_parametersTable.getColumnModel().getColumn(1)) != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_parametersTableModel.getFieldTypeComboBox()));
            }
            if ((tcElement = this.m_parametersTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_parametersTableModel.getModeTypeComboBox()));
            }
            if ((tcElement = this.m_parametersTable.getColumnModel().getColumn(3)) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            if ((tcElement = this.m_parametersTable.getColumnModel().getColumn(4)) != null) {
                tcElement.setCellEditor(new VWParamExpressionCellEditor(this.m_authPropertyData));
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            ++gbCons.gridy;
            gbCons.weighty = 0.2;
            gbCons.insets = new Insets(0, 2, 2, 2);
            VWToolbarBorder descriptionToolbar = new VWToolbarBorder(VWResource.s_prompt);
            this.getContentPane().add((Component)descriptionToolbar, gbCons);
            JPanel descriptionPanel = descriptionToolbar.getClientPanel();
            descriptionPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            descriptionPanel.add(new JScrollPane(this.m_descriptionTextArea));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initDialogControls() {
        try {
            JPanel clientPanel = new JPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 5);
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            clientPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            clientPanel.add((Component)this.m_helpButton, gbCons);
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 4;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(8, 2, 8, 2);
            this.getContentPane().add((Component)clientPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performClose() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh152.htm");
    }

    private void onDescription() {
        String description = this.m_descriptionTextArea.getText();
        int nRowIndex = this.m_parametersTable.getSelectedRow();
        this.m_parametersTableModel.setValueAt(description, nRowIndex, 5);
    }

    private void updateControlValues(int nRowIndex) {
        String description = (String)this.m_parametersTableModel.getValueAt(nRowIndex, 5);
        this.m_descriptionTextArea.setEnabled(true);
        this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
        this.m_descriptionTextArea.setText(description);
        this.m_descriptionTextArea.getDocument().addDocumentListener(this);
    }

    private void performDeleteAction() {
        int[] rows = this.m_parametersTable.getSelectedRows();
        if (rows != null) {
            this.m_parametersTableModel.deleteItems(rows);
        }
    }
}

